<?php
// No direct access
defined('_JEXEC') or die;

/**
 * Speaker Table class
 *
 * @package        Sermonspeaker.Administrator
 *
 * @since          ?
 */
class SermonspeakerTableSpeaker extends JTable
{
	/**
	 * Constructor
	 *
	 * @param  JDatabaseDriver $db JDatabaseDriver object.
	 *
	 * @since ?
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__sermon_speakers', 'id', $db);

		JTableObserverTags::createObserver($this, array('typeAlias' => 'com_sermonspeaker.speaker'));
		JTableObserverContenthistory::createObserver($this, array('typeAlias' => 'com_sermonspeaker.speaker'));
	}

	/**
	 * Overloaded bind function to pre-process the params.
	 *
	 * @param array  $array
	 * @param string $ignore
	 *
	 * @return null|string null is operation was satisfactory, otherwise returns an error
	 *
	 * @see      JTable::bind
	 *
	 * @since    1.5
	 */
	public function bind($array, $ignore = '')
	{
		if (isset($array['metadata']) && is_array($array['metadata']))
		{
			$registry = new Joomla\Registry\Registry;
			$registry->loadArray($array['metadata']);
			$array['metadata'] = (string) $registry;
		}

		return parent::bind($array, $ignore);
	}

	public function store($updateNulls = false)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
		if (empty($this->created_by))
		{
			$this->created_by = $user->id;
		}
		if (!intval($this->created))
		{
			$this->created = $date->toSql();
		}

		if ($this->id)
		{
			$this->modified    = $date->toSql();
			$this->modified_by = $user->id;
		}

		// Verify that the alias is unique
		$table = JTable::getInstance('speaker', 'SermonspeakerTable');

		if ($table->load(array('alias' => $this->alias, 'catid' => $this->catid)) && ($table->id != $this->id || $this->id == 0))
		{
			throw new Exception(JText::_('COM_SERMONSPEAKER_ERROR_ALIAS'));
		}

		return parent::store($updateNulls);
	}

	/**
	 * Method to set the publishing state for a row or list of rows in the database
	 * table.  The method respects checked out rows by other users and will attempt
	 * to checkin rows that it can after adjustments are made.
	 *
	 * @param    mixed   $pks    An optional array of primary key values to update.  If not
	 *                           set the instance property value is used.
	 * @param    integer $state  The publishing state. eg. [0 = unpublished, 1 = published]
	 * @param    integer $userId The user id of the user performing the operation.
	 *
	 * @return    boolean    True on success.
	 * @since    1.0.4
	 */
	public function publish($pks = null, $state = 1, $userId = 0)
	{
		// Initialise variables.
		$k = $this->_tbl_key;
		// Sanitize input.
		$pks    = Joomla\Utilities\ArrayHelper::toInteger($pks);
		$userId = (int) $userId;
		$state  = (int) $state;
		// If there are no primary keys set check to see if the instance key is set.
		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			// Nothing to set publishing state on, return false.
			else
			{
				$this->setError(JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));

				return false;
			}
		}
		// Build the WHERE clause for the primary keys.
		$where = $k . '=' . implode(' OR ' . $k . '=', $pks);
		// Determine if there is checkin support for the table.
		if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time'))
		{
			$checkin = '';
		}
		else
		{
			$checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
		}
		// Update the publishing state for rows with the given primary keys.
		$this->_db->setQuery(
			'UPDATE `' . $this->_tbl . '`' .
			' SET `state` = ' . (int) $state .
			' WHERE (' . $where . ')' .
			$checkin
		);
		$this->_db->execute();
		// Check for a database error.
		if ($this->_db->getErrorNum())
		{
			$this->setError($this->_db->getErrorMsg());

			return false;
		}
		// If checkin is supported and all rows were adjusted, check them in.
		if ($checkin && (count($pks) == $this->_db->getAffectedRows()))
		{
			// Checkin the rows.
			foreach ($pks as $pk)
			{
				$this->checkIn($pk);
			}
		}
		// If the JTable instance value is in the list of primary keys that were set, set the instance.
		if (in_array($this->$k, $pks))
		{
			$this->state = $state;
		}
		$this->setError('');

		return true;
	}
}
